## Buy-Intent Content Workflow (Services, Blogs, External)

### Objective
Build and rank three high-buy-intent service pages with supporting content to capture “ready to buy” traffic for essay services, while protecting brand trust (affordable-first positioning) and strengthening E‑E‑A‑T.

### Scope
- 3 money pages (≥1500 words each)
- 6 supporting blog posts, 2 per money page (≥2500 words each)
- 1 Blogger.com article, 1 Substack post
- Rich schema, internal linking, E‑E‑A‑T enhancements

### Targeted Core Intents
- Primary: buy essay writing service
- Price-sensitive: affordable essay writing service; cheap essay writing service (secondary positioning)

### Priority Keywords and Variants
- Buy intent: buy essay writing service; buy essays online; buy custom essay online; order essay online; buy essay fast; purchase essay
- Price-sensitive: affordable essay writing service; cheap essay writing service; buy cheap essays online; order cheap essay online; low‑cost essay writing; budget essay writing
- Long-tail modifiers: with plagiarism report; urgent/overnight; native writer; APA/MLA/Chicago; nursing/law/business/IT; college/master’s/PhD

### Site Architecture Touchpoints
- Services hub: `/services` → links to all service landers
- New routes to add:
  - `/services/affordable-essay-writing`
  - `/services/buy-essay-writing`
  - `/services/cheap-essay-writing`
- Consistent controller pattern: `ServiceController` → `PageService->getPageWithContent(slug)` → Inertia component → CMS content blocks

### CMS Model Alignment
- `Page` (page_type: service, template: specific React component)
- `PageSeo` (title, meta, canonical, structured_data, robots)
- `PageContent` (named blocks consumed by the React page)
- `PageMedia` (hero, benefits images)
- Blogs via `BlogPost` with `meta_data`, `structured_data`, `table_of_contents`

### React Components and Block Keys
- Option A: three specific pages (recommended for speed), mirroring `resources/js/Pages/Services/Essays.jsx`
  - Affordable page keys: `affordable_hero`, `affordable_overview`, `affordable_process`, `affordable_benefits`, `affordable_testimonials`, `affordable_faqs`, `affordable_cta`, `affordable_related_services`, `affordable_support_pages`, `affordable_resource_links`
  - Buy page keys: `buy_hero`, `buy_overview`, `buy_process`, `buy_benefits`, `buy_testimonials`, `buy_faqs`, `buy_cta`, `buy_related_services`, `buy_support_pages`, `buy_resource_links`
  - Cheap page keys: `cheap_hero`, `cheap_overview`, `cheap_process`, `cheap_benefits`, `cheap_testimonials`, `cheap_faqs`, `cheap_cta`, `cheap_related_services`, `cheap_support_pages`, `cheap_resource_links`

### Page Blueprints (Money Pages)
1) Affordable Essay Writing Service (Primary)
- URL: `/services/affordable-essay-writing`
- Title: Affordable Essay Writing Service | High Quality, Fair Prices
- Meta: Transparent pricing, expert writers, originality, on‑time delivery
- Sections: Problem/Solution; Pricing Table; Quality Controls (writer vetting, QA, plagiarism scan); Samples; Guarantees; Process; Turnaround Options; Trust (testimonials, badges); Strong CTAs
- FAQ (JSON‑LD): affordability vs quality; qualifications; plagiarism; discounts/milestones; deadlines

2) Buy Essay Writing Service (Highest intent)
- URL: `/services/buy-essay-writing`
- Title: Buy Essay Writing Service Online | Fast, 100% Original
- Meta: Vetted writers, secure checkout, transparent pricing, samples
- Sections: Why buy here; One‑screen order flow; Writer tiers/subjects; Delivery/pricing matrix; Security; Samples/outcomes; Social proof; CTAs
- FAQ: choose writer; revisions; confidentiality/legal; urgent deadlines; formatting styles

3) Cheap Essay Writing Service (Secondary, trust-preserving)
- URL: `/services/cheap-essay-writing`
- Title: Cheap Essay Writing Service You Can Trust (Honest, Transparent)
- Meta: Risks of “too cheap”, how we protect quality at lower price points
- Sections: Honest framing; Affordable vs Cheap comparison; Minimum viable scope; When to upgrade tiers; Guarantees that still apply; CTA to Affordable page
- FAQ: typical corners others cut; safest way on a tight budget; QA/plagiarism policy

### Supporting Blogs (6) — 2 per Money Page
- Affordable (link to Affordable page):
  1) How to Get Quality Essays on a Budget (Without Getting Burned)
  2) Real Pricing Breakdown: What Affects Essay Costs in 2025
- Buy (link to Buy page):
  1) Buy Essays Online: Safe, Legal, and Confidential? What You Need to Know
  2) Step‑by‑Step: How to Buy a Custom Essay That Actually Scores
- Cheap (link to Cheap page, nudge to Affordable):
  1) Cheap vs Affordable Essay Services: A Side‑by‑Side Comparison
  2) The Hidden Costs of “Too‑Cheap” Essays (And How to Avoid Them)

Each blog: ≥2500 words, TOC, Article/FAQ schema, author bio, references, strong in‑content CTAs.

### External Content
- Blogger.com: Buy Essays Online Safely: A 2025 Guide to Quality on a Budget → links to Affordable + Buy
- Substack: The Truth About “Cheap” Essay Writing — What Smart Buyers Do Instead → links primarily to Affordable, secondarily to Buy

### Schema and E‑E‑A‑T Requirements
- Money pages: Service + FAQ + Breadcrumb + Organization schema
- Blogs: Article (+ HowTo/FAQ where suitable)
- Sitewide: WebSite (SearchAction), BreadcrumbList, Organization
- E‑E‑A‑T:
  - Named expert authors with credentials and author pages
  - Organization details, policies (privacy/terms/refund/editorial)
  - Samples/case studies; references to authoritative sources
  - Testimonials/ratings (policy‑compliant usage)

### Internal Linking
- From blogs → money pages with descriptive anchors (“affordable essay writing service”, “buy essays online”)
- From money pages → “Guides & Resources” modules linking to the two supporting blogs
- Add “Top Services” sidebar to blog templates and breadcrumbs on money pages

### Technical and UX Checklist
- Core Web Vitals (LCP, CLS) on money pages and high‑impression blogs
- Canonical tags, noindex only when intentional; sitemap updates
- Preload critical images; compress/serve WebP; lazy‑load non‑critical media
- Track CTAs, FAQs, internal link clicks (analytics events already patterned in `Essays.jsx`)

### Editorial Standards
- Money pages: ≥1500 words; Blogs: ≥2500 words
- Mix primary keywords and long‑tails naturally; use H2/H3 structure; add TOC
- Include updated date, clear CTAs, and risk‑reversal guarantees

### Implementation Steps (per Money Page)
1) Backend
  - Add route in `routes/web.php`
  - Add controller method in `ServiceController` mapping slug → component
2) Frontend
  - Create React page component under `resources/js/Pages/Services/` with defined block keys
3) CMS Data
  - Create `Page` (slug/title/page_type: service)
  - Add `PageSeo` (title/meta/structured_data/canonical)
  - Add `PageContent` blocks per keys (hero, overview, process, benefits, testimonials, faqs, cta, related/support/resources)
  - Add `PageMedia` for hero/benefits images
4) Interlinking
  - Update related services/support links; add links from existing relevant posts
5) QA
  - Validate schema, SEO tags, CWV checks, navigation, CTA tracking

### Implementation Steps (per Blog)
1) Create `BlogPost` in Admin → set `published_at`, category, author, tags
2) Fill content (≥2500 words) + TOC + `meta_data` + `structured_data`
3) Add internal links to the corresponding money page
4) Publish and verify sitemap/indexing

### Timeline (suggested)
- Week 1: Affordable page + 2 blogs + Blogger article
- Week 2: Buy page + 2 blogs + Substack post
- Week 3: Cheap page + 2 blogs; reinforce internal links and schema; link acquisition outreach

### Measurement
- Track impressions/clicks/CTR/rank per target query
- Monitor conversions from CTAs (“Get a price”, “Place order”) and scroll depth
- Review Search Console for coverage/warnings and rich result eligibility

### Notes on Competitor Patterns (Edubirdie, EssayPro)
- Visible writer tiers, sample libraries, pricing calculators, extensive FAQs, trust badges
- We adopt strengths but keep honest “affordable vs cheap” positioning and stronger QA narrative

---
This document is the single source of truth for implementing the buy‑intent content initiative. Update it if routes, components, or CMS keys change.



