# Quick Guide: How to Edit Structured Data

## ✅ Your Homepage Structured Data Is Now Editable!

### Current Status:
- ✅ 4 Schema types configured (Organization, WebSite, Service, BreadcrumbList)
- ✅ All URLs updated to https://academicscribe.com
- ✅ Fully editable in admin interface
- ✅ Real-time validation included

---

## 🎯 How to Edit (3 Simple Steps)

### Step 1: Go to CMS Admin
```
http://127.0.0.1:8000/admin/cms/pages
```

### Step 2: Edit Homepage
- Find "Homepage" in the list
- Click the "Edit" button (pencil icon)

### Step 3: Edit Structured Data
- Click **"SEO"** tab at the top
- Scroll down to **"Structured Data (JSON-LD Schema)"** section
- Edit the JSON in the large textarea
- Watch for validation (green ✅ = valid, red ❌ = error)
- Click **"Save"** when done

---

## 📝 What's in Your Current Structured Data

```
Schema 1: Organization
├── Name: Academic Scribe
├── URL: https://academicscribe.com
├── Logo: https://academicscribe.com/images/logo.png
├── Phone: +1-555-123-4567 (UPDATE THIS!)
├── Social Media: 3 links (Facebook, Twitter, LinkedIn)
└── Contact Type: Customer Service

Schema 2: WebSite
├── Name: Academic Scribe
├── URL: https://academicscribe.com
└── Search Action: Enabled

Schema 3: Service
├── Service Type: Academic Writing
├── Area Served: Worldwide
└── Offers: 3 services with pricing

Schema 4: BreadcrumbList
└── Home navigation
```

---

## ⚡ Quick Edits You Might Want to Make

### 1. Update Phone Number (Currently Placeholder)

**Find this line:**
```json
"telephone": "+1-555-123-4567",
```

**Change to your actual number:**
```json
"telephone": "+1-YOUR-REAL-NUMBER",
```

### 2. Add More Social Media

**Find the sameAs array:**
```json
"sameAs": [
  "https://facebook.com/academicscribe",
  "https://twitter.com/academicscribe",
  "https://linkedin.com/company/academicscribe"
]
```

**Add more (if you have them):**
```json
"sameAs": [
  "https://facebook.com/academicscribe",
  "https://twitter.com/academicscribe",
  "https://linkedin.com/company/academicscribe",
  "https://instagram.com/academicscribe",
  "https://youtube.com/@academicscribe"
]
```

### 3. Update Service Pricing

**Find the service offers and update prices** to match your actual pricing.

---

## ✅ Features of the New Editor

1. **Live Validation** 
   - Green badge = Valid JSON ✅
   - Red badge = Syntax error ❌
   - Error message tells you what's wrong

2. **Formatted Preview**
   - See pretty-printed version below editor
   - Helps verify structure is correct

3. **Auto-save Compatible**
   - Changes save when you click "Save"
   - Cache clears automatically
   - Frontend updates immediately

4. **User-Friendly**
   - Monospace font for code
   - Large textarea for editing
   - Help text and examples included
   - Link to Schema.org docs

---

## 🔍 Where to Find It (Visual Guide)

```
Admin CMS Pages
└── Homepage (click Edit)
    └── Tabs: [Content] [SEO] [Media]
        └── Click [SEO] tab
            └── Sections:
                ├── Basic SEO (meta title, description)
                ├── Open Graph (social media)
                ├── Twitter Cards
                └── 📍 Structured Data (JSON-LD Schema) ← YOU ARE HERE
                    ├── Large textarea with JSON
                    ├── Validation indicator
                    └── Formatted preview
```

---

## 💾 Save & Verify

### After Editing:

1. **Click "Save" button** at bottom of page
2. **Wait for success message**
3. **Visit homepage** to verify
4. **View page source** (Ctrl+U or Cmd+U)
5. **Search for** `<script type="application/ld+json">`
6. **Confirm** your structured data appears

---

## 🎉 You're All Set!

Your structured data is now:
- ✅ Fully editable in admin
- ✅ Properly formatted with @graph
- ✅ Using correct domain (academicscribe.com)
- ✅ Includes 4 important schema types
- ✅ SEO-optimized for Google

**Just go edit it in the admin interface and save!**

---

**Location:** Admin → CMS → Pages → Homepage → SEO Tab → Structured Data section  
**File Reference:** `HOMEPAGE_STRUCTURED_DATA.json` (backup copy)  
**Documentation:** `STRUCTURED_DATA_GUIDE.md` (detailed guide)


