# Price Calculator - Quick Setup Guide

## 🚀 Quick Start (5 Minutes)

### Step 1: Run the Migration
```bash
php artisan migrate
```

### Step 2: Build Frontend
```bash
npm run build
# or for development
npm run dev
```

### Step 3: Visit Homepage
The price calculator section is now on your homepage!

---

## 📝 How to Add to Any Page

### Via Admin Panel:

1. **Navigate to CMS**
   ```
   Admin Dashboard → CMS → Pages
   ```

2. **Select Your Page**
   - Homepage
   - Service page (essay-writing, dissertations, etc.)
   - Blog post
   - Any other page

3. **Add Price Calculator Block**
   - Click "Add Content Block" or edit existing blocks
   - Select "Price Calculator" type (💰 icon)
   - Customize the content:
     - Title: "Get Instant Pricing"
     - Subtitle: "Calculate your price..."
     - Button text: "Calculate Your Price"
     - Choose style (gradient, white, gray, blue)
     - Choose alignment (center or left)

4. **Save**
   - Changes appear immediately on the frontend

---

## 🎨 Common Customizations

### Homepage Style (Bold & Centered)
```
Title: Get Instant Pricing for Your Assignment
Subtitle: Calculate the cost in seconds. No commitment required.
Button: Calculate Your Price
Style: Gradient background
Alignment: Center
```

### Service Page Style (Simple)
```
Title: Check Your Essay Price
Subtitle: See exactly how much your essay will cost.
Button: Get Quote
Style: White background
Alignment: Left
```

### Blog Post Style (Friendly)
```
Title: How Much Will Your Paper Cost?
Subtitle: Use our instant calculator to get a price estimate.
Button: Calculate Now
Style: Blue background
Alignment: Center
```

---

## 📊 Block Settings Reference

| Setting | Options | Default |
|---------|---------|---------|
| **Content** |
| Eyebrow | Any text | '' |
| Title | Any text | 'Get Instant Pricing' |
| Subtitle | Any text | 'Calculate the cost...' |
| Description | Rich text (HTML) | '' |
| **Button** |
| Button Text | Any text | 'Calculate Your Price' |
| Button Style | Primary / Secondary / Outline | Primary |
| **Style** |
| Background | Gradient / White / Gray / Blue | Gradient |
| Alignment | Center / Left | Center |
| **Toggles** |
| Show Eyebrow | Yes / No | Yes |
| Show Description | Yes / No | No |

---

## ✅ Checklist

### After Migration:
- [ ] Price calculator appears on homepage
- [ ] Clicking button opens calculator popup
- [ ] Calculator functions correctly (pricing API works)
- [ ] Section is editable in admin panel

### Adding to Service Pages:
- [ ] Edit service page in admin
- [ ] Add price calculator block
- [ ] Customize for that specific service
- [ ] Save and verify on frontend

### Adding to Blog Posts:
- [ ] Edit blog post in admin
- [ ] Add price calculator block (usually at the end)
- [ ] Customize message for blog context
- [ ] Save and verify on frontend

---

## 🔧 Files Overview

### Admin Editor:
```
resources/js/Components/Admin/PriceCalculatorBlockEditor.jsx
```
- Tabbed interface for content, button, and style settings
- Live preview panel
- Used in CMS admin panel

### Frontend Component:
```
resources/js/Components/CMS/PriceCalculatorSection.jsx
```
- Renders the section on pages
- Triggers the calculator popup
- Handles all styling and layout

### Integration Files:
```
resources/js/Pages/Admin/CMS/Components/ContentBlockEditor.jsx (modified)
resources/js/Components/CMS/ContentBlockRenderer.jsx (modified)
resources/js/Components/Services/servicePageUtils.js (modified)
resources/js/Pages/Services/DynamicService.jsx (modified)
resources/js/Pages/Home.jsx (modified)
```

---

## 🎯 Key Features

✅ **Add to ANY page** (homepage, services, blog, landing pages)
✅ **Fully customizable** via admin panel
✅ **No code required** for adding or editing
✅ **Live preview** while editing
✅ **Responsive** design (mobile, tablet, desktop)
✅ **Dark mode** compatible
✅ **Reorderable** (drag and drop with other blocks)
✅ **Can activate/deactivate** without deleting

---

## 🆘 Quick Troubleshooting

**Not seeing the calculator on homepage?**
- Run: `php artisan migrate`
- Check admin panel: CMS → Homepage → verify "Price Calculator" block is active

**Button not working?**
- Check browser console for errors
- Verify: `npm run build` was executed
- Clear browser cache

**Styles not applying?**
- Run: `npm run build`
- Hard refresh browser (Ctrl+Shift+R or Cmd+Shift+R)

---

## 📞 Support

If you encounter issues:
1. Check [PRICE_CALCULATOR_DYNAMIC_SECTION_COMPLETE.md](PRICE_CALCULATOR_DYNAMIC_SECTION_COMPLETE.md) for detailed documentation
2. Check browser console for JavaScript errors
3. Check Laravel logs: `storage/logs/laravel.log`
4. Verify database has the `price_calculator` block entries

---

**Quick Start Complete!** 🎉

The price calculator is now available as a dynamic section throughout your site.
