# Service Page Standardization & CMS Workflow

## 🎯 Objectives
- **Uniform Structure:** Ensure every service page—core and "money" pages—uses the same ordered set of `service_*` content blocks.
- **Unified Editing Experience:** Provide a single advanced editor experience in the CMS for all service pages, including long-form sections (migrating existing TinyMCE usage to TipTap).
- **Rapid Page Creation:** Make generating or importing JSON definitions for new service pages straightforward by following a fixed schema.
- **Granular Visibility Control:** Allow admins to activate, deactivate, and update any block or sub-block from the CMS interface.

---

## Phase 1 · Audit & Planning

### 1. Inventory Current Blocks
- Export block metadata for all service pages (`page_contents` records: `block_type`, `block_key`, `order`, `is_active`).
- Compare core services vs. money pages to confirm differences (extra long-form blocks, inconsistent block types).
- Document desired canonical block order (hero → overview → process → benefits → testimonials → FAQs → CTA → related links → support links → resource links → long-form sections).

### 2. Define Canonical Schema
- Agree on mandatory `service_*` blocks and optional long-form sections.
- Specify naming conventions: `service_<noun>` for core blocks, `service_scrollable` for scrollable sections (`<slug>_<topic>` keys stay unchanged).
- Draft JSON schema (keys, required fields, array structures, TipTap-compatible rich-text fields, `is_active` flag placement).

### 3. Editor Stack Alignment
- Confirm TipTap configuration currently used on the homepage (extensions, menu items, output format).
- Plan migration of existing service editors from TinyMCE to TipTap to ensure consistent UX and avoid TinyMCE monthly limits.
- Identify any data transformations needed to convert stored TinyMCE HTML to TipTap JSON (or decide to keep storing HTML while editing with TipTap).

### 4. Scaffolding Strategy
- Establish `resources/content/templates/service-page.json` as the single canonical template for new service pages.
- Plan shared scaffolding service (consumed by CLI and CMS) that reads the template, injects slug/title, and creates the full block set with default `is_active` flags.

---

## Phase 2 · Backend Alignment

### 1. Seeder & Import Strategy
- Update `BuyIntentPagesSeeder` to output canonical `service_*` block types and keys.
- Normalize markdown-to-block mapping to write `block_type` = `service_scrollable` and persist rich-text HTML for the scrollable sections.
- Add migration or artisan command to convert existing records: rename block types, update keys, preserve content & order.

### 2. API & Model Adjustments
- Ensure `PageContent` cast includes new structures (e.g., `sections` array, per-section `is_active`).
- Extend validation rules for block updates (controller/service layer) to enforce schema and accept TipTap payloads (JSON or HTML depending on storage format).
- Introduce batch update endpoint if needed for JSON imports.

### 3. Content Migration
- Audit existing rich-text fields; convert stored TinyMCE markup to TipTap-friendly format if required.
- Provide fallback rendering to handle legacy HTML while migration completes.

### 4. Scaffolding Service Implementation
- Build a backend service class that loads the canonical template, merges page metadata, and persists blocks/SEO records.
- Expose it via `php artisan service:scaffold {slug}` and reuse the same service inside CMS “Create Service Page” actions.

---

## Phase 3 · CMS Editor Enhancements

### 1. Unified Block Renderer
- Map standardized block types to existing `Service*BlockEditor` components.
- Create new editor for scrollable sections (`ServiceLongformBlockEditor`) supporting:
  - TipTap-based rich text editing for the long-form body.
  - Optional legacy section content import (auto-flattened into the rich-text field).
  - Height configuration and visibility controls.

### 2. Visibility Controls
- Confirm `toggleBlockStatus` persists `is_active` flag.
- Surface per-item toggles inside dynamic arrays (key points, steps, benefits, long-form sections).
- Display active/inactive state in editor list (badges, sorting options).

### 3. UX Polish
- Replace remaining TinyMCE instances in service editors with standardized TipTap component (reuse homepage implementation).
- Add preset templates/default items for new service pages by invoking the shared scaffolding service.
- Provide schema preview/validation hints alongside JSON import.
- Log updates (audit trail) for block visibility and content changes.

---

## Phase 4 · Frontend Adjustments

### 1. Component Harmonization
- Ensure `ServiceHero`, `ServiceOverview`, etc. gracefully handle inactive items.
- Build/extend `ScrollableContentSection` to read the stored HTML for each scrollable block and hide inactive entries.
- Confirm ordering and fallbacks match canonical schema.
- Verify frontend can render TipTap output (HTML) consistently across components.

### 2. Dynamic Rendering Pipeline
- Update page-level components (e.g., `Services/AffordableEssayWriting.jsx`) to consume standardized keys.
- Optionally consolidate into one `Services/DynamicService.jsx` component fed by canonical schema.

---

## Phase 5 · Content Operations

### 1. JSON Authoring Workflow
- Document schema in `/resources/content/templates/service-page.json` and keep it synchronized with the scaffolding service.
- Provide example JSON + CLI command to import/create a new service page using the shared scaffolder.
- Add validation script to check block ordering, required fields, `is_active` flags, and TipTap payload format.

### 2. Training & Guidelines
- Publish short guide for non-developers on using the CMS editors (TipTap tabs, visibility toggles, long-form editing).
- Outline workflow for: run scaffold (CLI or CMS) → update content → toggle sections → publish.

---

## Phase 6 · Testing & QA

### 1. Automated Checks
- Write integration tests covering block rename migration and CMS update endpoints.
- Add frontend tests (React testing library/Playwright) for block toggle behavior and TipTap rendering.
- Test scaffolding service: ensure newly scaffolded pages match schema and defaults.

### 2. Manual QA Checklist
- Edit each block type via CMS with TipTap, ensure save & preview.
- Toggle blocks/subsections off and on, confirm frontend updates.
- Scaffold a new service page via CLI and CMS, verify schema adherence and rendering.

---

## Phase 7 · Rollout

- Deploy backend migration and CMS updates.
- Re-seed or run migration scripts on production data.
- Ship scaffolding CLI + CMS integration; provide template update instructions.
- Monitor logs/analytics for block activation events and page performance.
- Iterate on editor UX based on content team feedback.

---

## Next Steps Snapshot
1. Approve canonical block schema and naming conventions.
2. Update seeders + run migration to align existing pages.
3. Implement long-form block editor with TipTap and visibility controls.
4. Finalize canonical template and scaffolding service (CLI + CMS integration).
5. Train content team on the unified TipTap-based workflow.
