<?php

namespace App\Console\Commands;

use App\Services\ServicePageScaffolder;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use Throwable;

class ScaffoldServicePage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'service:scaffold {slug : The slug for the service page} {--title= : Optional human readable title} {--publish : Publish the page immediately}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Scaffold a new service page using the canonical template.';

    public function handle(ServicePageScaffolder $scaffolder): int
    {
        $slugArgument = $this->argument('slug');
        $slug = Str::slug($slugArgument);
        $title = $this->option('title') ?? Str::headline(str_replace('-', ' ', $slug));
        $publish = (bool) $this->option('publish');

        try {
            $overrides = [
                'title' => $title,
                'page' => array_filter([
                    'status' => $publish ? 'published' : 'draft',
                    'published_at' => $publish ? now() : null,
                ]),
            ];

            $result = $scaffolder->scaffold($slug, $overrides);
        } catch (Throwable $exception) {
            $this->error($exception->getMessage());

            return self::FAILURE;
        }

        $page = $result['page'];
        $this->info("Service page '{$page->title}' scaffolded with slug '{$page->slug}'.");
        $this->line('Blocks created: ' . collect($result['blocks'])->count());

        if ($publish) {
            $this->comment('Page published.');
        } else {
            $this->comment('Page saved as draft. Set status to published when ready.');
        }

        return self::SUCCESS;
    }
}










