<?php

namespace App\Helpers;

use App\Services\ImageOptimizationService;

class ImageHelper
{
    protected static $imageService;

    /**
     * Get the image optimization service instance
     */
    protected static function getImageService(): ImageOptimizationService
    {
        if (!static::$imageService) {
            static::$imageService = app(ImageOptimizationService::class);
        }

        return static::$imageService;
    }

    /**
     * Get optimized image data for React Picture component
     *
     * @param string $imagePath
     * @param string $alt
     * @param string $conversionType
     * @return array
     */
    public static function getResponsiveImage(string $imagePath, string $alt = '', string $conversionType = 'blog'): array
    {
        return static::getImageService()->getResponsiveImageData($imagePath, $conversionType, $alt);
    }

    /**
     * Get hero image data
     */
    public static function getHeroImage(string $imagePath, string $alt = ''): array
    {
        return static::getResponsiveImage($imagePath, $alt, 'hero');
    }

    /**
     * Get blog image data
     */
    public static function getBlogImage(string $imagePath, string $alt = ''): array
    {
        return static::getResponsiveImage($imagePath, $alt, 'blog');
    }

    /**
     * Get service image data
     */
    public static function getServiceImage(string $imagePath, string $alt = ''): array
    {
        return static::getResponsiveImage($imagePath, $alt, 'service');
    }

    /**
     * Get thumbnail image data
     */
    public static function getThumbnailImage(string $imagePath, string $alt = ''): array
    {
        return static::getResponsiveImage($imagePath, $alt, 'thumbnail');
    }

    /**
     * Get avatar image data
     */
    public static function getAvatarImage(string $imagePath, string $alt = ''): array
    {
        return static::getResponsiveImage($imagePath, $alt, 'avatar');
    }

    /**
     * Get logo image data
     */
    public static function getLogoImage(string $imagePath, string $alt = ''): array
    {
        return static::getResponsiveImage($imagePath, $alt, 'logo');
    }
}
