<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AcademicLevel;
use App\Models\PaperType;
use App\Models\Subject;
use App\Models\Pricing;
use App\Models\AdminSetting;
use Illuminate\Http\JsonResponse;

class PricingDataController extends Controller
{
    /**
     * Get all pricing data needed for the price calculator
     * This endpoint is public and doesn't require authentication
     *
     * @return JsonResponse
     */
    public function index(): JsonResponse
    {
        try {
            $data = [
                'academic_levels' => AcademicLevel::all(),
                'paper_types' => PaperType::all(),
                'subjects' => Subject::all(),
                'deadlines' => Pricing::all(),
                'single_slide_price' => AdminSetting::where('price_per_slide', '>', 0)
                    ->value('price_per_slide') ?? 5,
            ];

            return response()->json([
                'success' => true,
                'data' => $data,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Unable to fetch pricing data.',
                'error' => config('app.debug') ? $e->getMessage() : null,
            ], 500);
        }
    }
}

