<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Services\RefundService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RefundController extends Controller
{
    /**
     * @var RefundService
     */
    protected $refundService;

    /**
     * Create a new controller instance.
     *
     * @param RefundService $refundService
     * @return void
     */
    public function __construct(RefundService $refundService)
    {
        $this->refundService = $refundService;
    }

    /**
     * Get refund information for an order.
     *
     * @param Request $request
     * @param int $orderId
     * @return \Illuminate\Http\JsonResponse
     */
    public function getOrderRefundInfo(Request $request, $orderId)
    {
        $order = Order::findOrFail($orderId);

        // Check if user is authorized to view this order
        if (Auth::id() !== $order->user_id && Auth::user()->user_type !== 'admin') {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized'
            ], 403);
        }

        $refundInfo = $this->refundService->getOrderRefundInfo($orderId);

        return response()->json([
            'success' => true,
            'refundInfo' => $refundInfo
        ]);
    }
}
