<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use App\Models\Page;

class GuaranteesController extends Controller
{
    public function index()
    {
        // Try to load from CMS first
        $cmsPage = Page::where('slug', 'guarantees')
            ->with(['contentBlocks' => function($query) {
                $query->where('is_active', true)->orderBy('order');
            }, 'seo'])
            ->first();

        if ($cmsPage && $cmsPage->contentBlocks->isNotEmpty()) {
            // Use CMS data
            return Inertia::render('Guarantees', [
                'page' => $cmsPage,
                'contentBlocks' => $cmsPage->contentBlocks,
                'seoData' => [
                    'title' => $cmsPage->seo->meta_title ?? 'Our Guarantees - Academic Scribe',
                    'description' => $cmsPage->seo->meta_description ?? '',
                    'canonicalUrl' => $cmsPage->seo->canonical_url ?? url('/guarantees'),
                    'ogUrl' => $cmsPage->seo->canonical_url ?? url('/guarantees'),
                    'ogTitle' => $cmsPage->seo->og_title ?? '',
                    'ogDescription' => $cmsPage->seo->og_description ?? '',
                    'ogImage' => $cmsPage->seo->og_image ?? '',
                ],
                'openGraph' => [
                    'title' => $cmsPage->seo->og_title,
                    'description' => $cmsPage->seo->og_description,
                    'image' => $cmsPage->seo->og_image,
                ],
                'structuredData' => $cmsPage->seo->structured_data ?? [],
                'isCMS' => true
            ]);
        }

        // Fallback to static data
        return Inertia::render('Guarantees', [
            'seoData' => [
                'title' => 'Our Guarantees - Academic Scribe',
                'description' => 'Learn about our quality guarantees including plagiarism-free content, money-back guarantee, and more.',
                'canonicalUrl' => url('/guarantees'),
                'ogUrl' => url('/guarantees'),
            ],
            'isCMS' => false
        ]);
    }
}

