<?php

namespace App\Http\Controllers;

use App\Models\Page;
use App\Models\PageContent;
use App\Models\PageSeo;
use App\Services\PageService;
use App\Services\SEOService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class PricingController extends Controller
{
    protected $pageService;
    protected $seoService;

    public function __construct(PageService $pageService, SEOService $seoService)
    {
        $this->pageService = $pageService;
        $this->seoService = $seoService;
    }

    public function index()
    {
        // Try to load from CMS first
        $page = Page::where('slug', 'pricing')
            ->with(['contentBlocks' => function($query) {
                $query->where('is_active', true)->orderBy('order');
            }, 'seo'])
            ->first();
        
        if ($page && $page->contentBlocks->isNotEmpty()) {
            $seoData = $page->seo;
            $seoArray = $seoData ? $seoData->toArray() : [];
            $pageData = [
                'title' => $page->title,
                'canonical_url' => $seoArray['canonical_url'] ?? url()->current(),
            ];
            $openGraph = $this->seoService->generateOpenGraphData($pageData, $seoArray);
            $structuredData = $this->seoService->generateStructuredData('service', $pageData, $seoArray);
            
            return Inertia::render('Pricing', [
                'page' => $page,
                'contentBlocks' => $page->contentBlocks,
                'seoData' => $seoData,
                'openGraph' => $openGraph,
                'structuredData' => $structuredData,
                'isCMS' => true
            ]);
        }
        
        // Fallback to static data (existing implementation)
        return Inertia::render('Pricing', [
            'isCMS' => false
        ]);
    }
}
