<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use App\Models\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class ReviewsController extends Controller
{
    public function index(Request $request)
    {
        // Try to load from CMS first
        $cmsPage = Page::where('slug', 'reviews')
            ->with(['contentBlocks' => function($query) {
                $query->where('is_active', true)->orderBy('order');
            }, 'seo'])
            ->first();

        if ($cmsPage && $cmsPage->seo) {
            // Use CMS data
            return Inertia::render('Reviews', [
                'page' => $cmsPage,
                'contentBlocks' => $cmsPage->contentBlocks,
                'seoData' => [
                    'title' => $cmsPage->seo->meta_title,
                    'description' => $cmsPage->seo->meta_description,
                    'keywords' => $cmsPage->seo->meta_keywords,
                    'canonicalUrl' => $cmsPage->seo->canonical_url,
                    'ogUrl' => $cmsPage->seo->canonical_url,
                    'ogTitle' => $cmsPage->seo->og_title,
                    'ogDescription' => $cmsPage->seo->og_description,
                    'ogImage' => $cmsPage->seo->og_image,
                    'twitterTitle' => $cmsPage->seo->twitter_title,
                    'twitterDescription' => $cmsPage->seo->twitter_description,
                    'twitterImage' => $cmsPage->seo->twitter_image,
                ],
                'openGraph' => [
                    'title' => $cmsPage->seo->og_title,
                    'description' => $cmsPage->seo->og_description,
                    'image' => $cmsPage->seo->og_image,
                ],
                'structuredData' => $cmsPage->seo->structured_data ?? [],
                'isCMS' => true
            ]);
        }

        // Fallback to cached static SEO data
        $seoData = Cache::remember('reviews_seo_data', 3600, function () {
            return [
                'title' => 'Customer Reviews & Testimonials | 2800+ Verified Student Reviews | Academic Scribe',
                'description' => 'Read 2800+ verified customer reviews and student testimonials for our essay writing, research paper, dissertation, and assignment help services. 4.9/5 star rating from satisfied students worldwide.',
                'keywords' => 'customer reviews, student testimonials, essay writing reviews, research paper reviews, dissertation reviews, assignment help reviews, academic writing testimonials, verified customer feedback, 5-star reviews, satisfied students, quality reviews, service ratings, customer satisfaction, genuine reviews, authentic testimonials, student success stories, academic help reviews, writing service feedback, reliable reviews, trustworthy testimonials',
                'ogTitle' => '2800+ Verified Customer Reviews | Academic Writing Service Reviews',
                'ogDescription' => 'Read authentic student testimonials and customer reviews. 4.9/5 star rating from satisfied customers. Verified reviews for essay writing, research papers, dissertations, and more.',
                'ogImage' => asset('images/customer-reviews-og.jpg'),
                'ogUrl' => url('/reviews'),
                'twitterTitle' => '2800+ Verified Customer Reviews | Student Testimonials',
                'twitterDescription' => 'Read authentic student testimonials and customer reviews. 4.9/5 star rating from satisfied customers worldwide.',
                'twitterImage' => asset('images/customer-reviews-twitter.jpg'),
                'canonicalUrl' => url('/reviews'),
            ];
        });

        return Inertia::render('Reviews', [
            'seoData' => $seoData,
            'isCMS' => false
        ]);
    }
}
