<?php

namespace App\Http\Controllers;

use App\Models\Subject;

use Illuminate\Http\Request;

class SubjectsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $subjects = Subject::paginate(8);
        return inertia('Admin/Subjects/Index', [
            'subjects' => $subjects,
        ]);
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return inertia('Admin/Subjects/Create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:191|unique:subjects',
            'value' => 'required|numeric'
        ]);
        $subject = Subject::create($validated);
        return redirect()
            ->route('subjects.index')
            ->with('message', 'Subject created successfully');
    }



    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Subject $subject)
    {

        return inertia('Admin/Subjects/Edit', [
            'subject' => $subject,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Subject $subject)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:191|unique:subjects,name,' . $subject->id,
            'value' => 'required|numeric'
        ]);
        $subject->update($validated);
        return redirect()
            ->route('subjects.index')
            ->with('message', 'Subject updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Subject $subject)
    {
        $subject->delete();
        return redirect()
            ->route('subjects.index')
            ->with('message', 'Subject deleted successfully');
    }
}
