<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use App\Models\Page;

class WritersController extends Controller
{
    public function index()
    {
        // Try to load from CMS first
        $cmsPage = Page::where('slug', 'writers')
            ->with(['contentBlocks' => function($query) {
                $query->where('is_active', true)->orderBy('order');
            }, 'seo'])
            ->first();

        if ($cmsPage && $cmsPage->contentBlocks->isNotEmpty()) {
            // Use CMS data
            return Inertia::render('Writers', [
                'page' => $cmsPage,
                'contentBlocks' => $cmsPage->contentBlocks,
                'seoData' => [
                    'title' => $cmsPage->seo->meta_title,
                    'description' => $cmsPage->seo->meta_description,
                    'keywords' => $cmsPage->seo->meta_keywords,
                    'canonicalUrl' => $cmsPage->seo->canonical_url,
                    'ogUrl' => $cmsPage->seo->canonical_url,
                    'ogTitle' => $cmsPage->seo->og_title,
                    'ogDescription' => $cmsPage->seo->og_description,
                    'ogImage' => $cmsPage->seo->og_image,
                    'twitterTitle' => $cmsPage->seo->twitter_title,
                    'twitterDescription' => $cmsPage->seo->twitter_description,
                    'twitterImage' => $cmsPage->seo->twitter_image,
                ],
                'openGraph' => [
                    'title' => $cmsPage->seo->og_title,
                    'description' => $cmsPage->seo->og_description,
                    'image' => $cmsPage->seo->og_image,
                ],
                'structuredData' => $cmsPage->seo->structured_data ?? [],
                'isCMS' => true
            ]);
        }

        // Fallback to static data
        return Inertia::render('Writers', [
            'seoData' => [
                'title' => 'Professional Essay Writers for Hire | 847+ Expert Academic Writers | Academic Scribe',
                'description' => 'Hire professional essay writers with PhD and Masters degrees. 847+ qualified academic writers available for custom essays, research papers, dissertations, and assignments. Expert writers for students worldwide.',
                'keywords' => 'essay writers for hire, professional academic writers, expert writers, PhD writers, research paper writers, dissertation writers, assignment help writers, qualified essay writers, academic writing experts, hire essay writer, professional writing service, custom essay writers',
                'canonicalUrl' => url('/writers'),
                'ogUrl' => url('/writers'),
            ],
            'isCMS' => false
        ]);
    }
}




