<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AcademicSubject extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description'];

    /**
     * Get the writer profiles for the academic subject.
     */
    public function writerProfiles()
    {
        return $this->belongsToMany(WriterProfile::class, 'subjects');
    }
}
