<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdminSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'writer_fee',
        'writer_deadline',
        'enable_coupon',
        'price_per_slide',
        'enable_stripe_payment',
        'questions_test_duration',
        'essay_test_duration',
        'quality_bonus',
        'quality_penalty',
        'delay_penalty_per_hour',
        // Third-party scripts
        'enable_gtm',
        'gtm_id',
        'gtm_delay',
        'enable_tawkto',
        'tawkto_property_id',
        'tawkto_widget_id',
        'tawkto_delay',
        'enable_comm100',
        'comm100_site_id',
        'comm100_code_plan',
        'comm100_div_id',
        'comm100_delay',
    ];

    protected $casts = [
        'enable_coupon' => 'boolean',
        'enable_stripe_payment' => 'boolean',
        'questions_test_duration' => 'integer',
        'essay_test_duration' => 'integer',
        'quality_bonus' => 'decimal:2',
        'quality_penalty' => 'decimal:2',
        'delay_penalty_per_hour' => 'decimal:2',
        // Third-party scripts
        'enable_gtm' => 'boolean',
        'gtm_delay' => 'integer',
        'enable_tawkto' => 'boolean',
        'tawkto_delay' => 'integer',
        'enable_comm100' => 'boolean',
        'comm100_delay' => 'integer',
    ];


    public $timestamps = false;
}
