<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subject extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'value',
        'name'
    ];

    // **
    //  * Get the writer profiles for the subject.
    //  */
    public function writerProfiles()
    {
        return $this->belongsToMany(WriterProfile::class, 'writer_subjects');
    }
}
