<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WriterPaymentAccount extends Model
{
    use HasFactory;

    protected $fillable = [
        'writer_profile_id',
        'payment_method_id',
        'account_details',
        'is_primary',
        'is_verified',
    ];

    protected $casts = [
        'is_primary' => 'boolean',
        'is_verified' => 'boolean',
    ];

    /**
     * Get the writer profile that owns the payment account.
     */
    public function writerProfile()
    {
        return $this->belongsTo(WriterProfile::class);
    }

    /**
     * Get the payment method for this account.
     */
    public function paymentMethod()
    {
        return $this->belongsTo(WriterPaymentMethod::class);
    }
}
