<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WriterWorkSample extends Model
{
    use HasFactory;

    protected $fillable = ['writer_profile_id', 'title', 'description', 'file_path', 'file_type', 'file_size'];

    /**
     * Get the writer profile that owns the work sample.
     */
    public function writerProfile()
    {
        return $this->belongsTo(WriterProfile::class);
    }
}
