<?php

namespace App\Policies;

use App\Models\PaymentMethod;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class PaymentMethodPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any payment methods.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        // Allow admins and super admins to view payment methods
        return $user->isAdmin() || $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can view the payment method.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PaymentMethod  $paymentMethod
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, PaymentMethod $paymentMethod)
    {
        // Allow admins and super admins to view payment method details
        return $user->isAdmin() || $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can create payment methods.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        // Only super admins can create payment methods
        return $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can update the payment method.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PaymentMethod  $paymentMethod
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, PaymentMethod $paymentMethod)
    {
        // Only super admins can update payment methods
        return $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can delete the payment method.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PaymentMethod  $paymentMethod
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, PaymentMethod $paymentMethod)
    {
        // Only super admins can delete payment methods
        return $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can toggle payment method active status.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PaymentMethod  $paymentMethod
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function toggleStatus(User $user, PaymentMethod $paymentMethod)
    {
        // Only super admins can activate/deactivate payment methods
        return $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can test payment method connections.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\PaymentMethod  $paymentMethod
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function testConnection(User $user, PaymentMethod $paymentMethod)
    {
        // Allow admins and super admins to test connections
        return $user->isAdmin() || $user->isSuperAdmin();
    }
}
