<?php

namespace App\Providers;

use App\Models\User;
use App\Models\Order;
use App\Policies\OrderPolicy;
use App\Observers\UserObserver;
use App\Services\RefundService;
use Illuminate\Support\Facades\Vite;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use App\Services\ImageOptimizationService;

class AppServiceProvider extends ServiceProvider
{

    protected $policies = [
        Order::class => OrderPolicy::class,
    ];
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Register the RefundService as a singleton
        $this->app->singleton(RefundService::class, function ($app) {
            return new RefundService();
        });
        $this->app->singleton(ImageOptimizationService::class, function ($app) {
            return new ImageOptimizationService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register the policy


        Schema::defaultStringLength(191);
        Vite::prefetch(concurrency: 3);
        User::observe(UserObserver::class);
    }
}
