<?php

namespace App\Services;

class NicknameGeneratorService
{
    /**
     * Generate a nickname for a writer based on their ID and name
     *
     * @param int $writerId
     * @param string $writerName
     * @return string
     */
    public static function generateNickname(int $writerId, string $writerName): string
    {
        // Clean the name - remove special characters and convert to lowercase
        $cleanName = preg_replace('/[^a-zA-Z0-9]/', '', strtolower($writerName));
        
        // Take first 3-5 characters of the name
        $namePart = substr($cleanName, 0, min(5, strlen($cleanName)));
        
        // If name is too short, pad with random characters
        if (strlen($namePart) < 3) {
            $namePart = $namePart . substr(md5($writerName), 0, 3 - strlen($namePart));
        }
        
        // Combine name part with writer ID
        $nickname = $namePart . $writerId;
        
        return $nickname;
    }
} 