<?php

namespace App\Services\Payments;

use App\Models\Order;
use App\Models\Payment;

interface PaymentServiceInterface
{
    /**
     * Initialize a payment for an order.
     *
     * @param Order $order
     * @return array Payment initialization data
     */
    public function initializePayment(Order $order): array;

    /**
     * Process a payment after user confirmation.
     *
     * @param Order $order
     * @param array $paymentData
     * @return Payment
     */
    public function processPayment(Order $order, array $paymentData): Payment;

    /**
     * Verify a payment using provider-specific methods.
     *
     * @param string $transactionId
     * @return bool
     */
    public function verifyPayment(string $transactionId): bool;

    /**
     * Handle webhook events from the payment provider.
     *
     * @param array $payload
     * @return bool
     */
    public function handleWebhook(array $payload): bool;

    /**
     * Get the client-side configuration needed for the payment method.
     *
     * @return array
     */
    public function getClientConfig(): array;

    /**
     * Test connection with payment gateway.
     *
     * @return array
     */
    public function testConnection(): array;

    /**
     * Process a refund for a payment.
     *
     * @param Payment $payment
     * @param float $amount
     * @param string $reason
     * @return array
     */
    public function processRefund(Payment $payment, float $amount, string $reason): array;
}
