<?php

namespace App\Services;

class SchemaMarkupService
{
    /**
     * Generate Organization schema markup
     */
    public static function getOrganizationSchema()
    {
        return [
            "@context" => "https://schema.org",
            "@type" => "Organization",
            "name" => "Academic Scribe",
            "description" => "Professional academic writing services with expert PhD writers",
            "url" => config('app.url'),
            "logo" => config('app.url') . "/images/logo.png",
            "contactPoint" => [
                "@type" => "ContactPoint",
                "telephone" => "+1-555-123-4567",
                "contactType" => "customer service",
                "availableLanguage" => "English",
                "areaServed" => "Worldwide"
            ],
            "sameAs" => [
                "https://www.facebook.com/academicscribe",
                "https://www.twitter.com/academicscribe",
                "https://www.linkedin.com/company/academicscribe"
            ],
            "address" => [
                "@type" => "PostalAddress",
                "addressCountry" => "US",
                "addressRegion" => "CA",
                "addressLocality" => "Los Angeles"
            ]
        ];
    }

    /**
     * Generate Service schema markup
     */
    public static function getServiceSchema($serviceName, $description, $url)
    {
        return [
            "@context" => "https://schema.org",
            "@type" => "Service",
            "name" => $serviceName,
            "description" => $description,
            "url" => $url,
            "provider" => [
                "@type" => "Organization",
                "name" => "Academic Scribe",
                "url" => config('app.url')
            ],
            "serviceType" => "Academic Writing Service",
            "areaServed" => "Worldwide",
            "availableChannel" => [
                "@type" => "ServiceChannel",
                "serviceUrl" => $url,
                "availableLanguage" => "English"
            ]
        ];
    }

    /**
     * Generate FAQ schema markup
     */
    public static function getFAQSchema($faqs)
    {
        $faqItems = [];

        foreach ($faqs as $faq) {
            $faqItems[] = [
                "@type" => "Question",
                "name" => $faq['question'],
                "acceptedAnswer" => [
                    "@type" => "Answer",
                    "text" => $faq['answer']
                ]
            ];
        }

        return [
            "@context" => "https://schema.org",
            "@type" => "FAQPage",
            "mainEntity" => $faqItems
        ];
    }

    /**
     * Generate Review schema markup
     */
    public static function getReviewSchema($reviews)
    {
        $reviewItems = [];

        foreach ($reviews as $review) {
            $reviewItems[] = [
                "@type" => "Review",
                "author" => [
                    "@type" => "Person",
                    "name" => $review['author']
                ],
                "reviewRating" => [
                    "@type" => "Rating",
                    "ratingValue" => $review['rating'],
                    "bestRating" => "5"
                ],
                "reviewBody" => $review['text']
            ];
        }

        return [
            "@context" => "https://schema.org",
            "@type" => "Organization",
            "name" => "Academic Scribe",
            "review" => $reviewItems
        ];
    }

    /**
     * Generate BreadcrumbList schema markup
     */
    public static function getBreadcrumbSchema($breadcrumbs)
    {
        $listItems = [];

        foreach ($breadcrumbs as $index => $breadcrumb) {
            $listItems[] = [
                "@type" => "ListItem",
                "position" => $index + 1,
                "name" => $breadcrumb['name'],
                "item" => $breadcrumb['url']
            ];
        }

        return [
            "@context" => "https://schema.org",
            "@type" => "BreadcrumbList",
            "itemListElement" => $listItems
        ];
    }
}
