<?php

use Illuminate\Foundation\Application;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        channels: __DIR__ . '/../routes/channels.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->web(append: [
            \App\Http\Middleware\HandleInertiaRequests::class,
            \App\Http\Middleware\InjectMetaTagsForCrawlers::class, // Inject meta tags for social media crawlers
            \Illuminate\Http\Middleware\AddLinkHeadersForPreloadedAssets::class,
            \App\Http\Middleware\CheckExpiredEssayTests::class, // to run all web routes
            \App\Http\Middleware\CheckExpiredQuestionTests::class, // to run all web routes
            \App\Http\Middleware\CacheControl::class, // HTTP caching headers for performance
        ]);

        $middleware->alias([
            'admin' => \App\Http\Middleware\AdminMiddleware::class,
            'writer' => \App\Http\Middleware\WriterMiddleware::class,
            'client' => \App\Http\Middleware\ClientMiddleware::class,
            'validate.blog.upload' => \App\Http\Middleware\ValidateBlogUpload::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })
    ->withSchedule(function (Schedule $schedule) {
        // Schedule automatic cleanup of old optimized images (weekly)
        $schedule->command('images:clean --orphaned --older-than=30')
            ->weekly()
            ->sundays()
            ->at('02:00')
            ->description('Clean up orphaned and old optimized images');
    })
    ->create();
