<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Blog Upload Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for blog JavaScript file uploads and processing
    |
    */

    'file_validation' => [
        // Allowed file extensions
        'allowed_extensions' => ['js', 'mjs'],

        // Allowed MIME types
        'allowed_mime_types' => [
            'text/javascript',
            'application/javascript',
            'text/plain',
        ],

        // Maximum file size in bytes (5MB)
        'max_file_size' => 5 * 1024 * 1024,

        // Maximum number of files per upload
        'max_files_per_upload' => 10,

        // Required file structure validation
        'required_fields' => [
            'title',
            'slug',
            'excerpt',
            'content',
            'category',
            'publishedAt',
        ],

        // Optional fields that can be present
        'optional_fields' => [
            'subtitle',
            'author',
            'tags',
            'keywords',
            'readTime',
            'difficulty',
            'featuredImage',
            'meta',
            'openGraph',
            'twitter',
            'structuredData',
            'tableOfContents',
            'relatedPosts',
            'socialSharing',
            'analytics',
        ],
    ],

    'security' => [
        // Scan for malicious JavaScript patterns
        'scan_for_malicious_code' => true,

        // Blocked JavaScript patterns
        'blocked_patterns' => [
            'eval\s*\(',
            'Function\s*\(',
            'setTimeout\s*\(',
            'setInterval\s*\(',
            'document\.write',
            'innerHTML\s*=',
            'outerHTML\s*=',
            'location\.href',
            'window\.open',
            'XMLHttpRequest',
            'fetch\s*\(',
            'import\s*\(',
            'require\s*\(',
        ],

        // Maximum execution time for file processing (seconds)
        'max_processing_time' => 300,

        // Quarantine suspicious files
        'quarantine_suspicious_files' => true,
    ],

    'processing' => [
        // Temporary file retention time (minutes)
        'temp_file_retention' => 60,

        // Auto-cleanup processed files
        'auto_cleanup' => true,

        // Backup original files
        'backup_originals' => true,

        // Enable batch processing
        'enable_batch_processing' => true,

        // Maximum batch size
        'max_batch_size' => 50,
    ],

    'storage' => [
        // Storage disk for uploads
        'upload_disk' => 'blog_uploads',

        // Storage disk for temporary files
        'temp_disk' => 'temp_uploads',

        // Storage disk for backups
        'backup_disk' => 'blog_uploads',

        // Directory structure
        'directories' => [
            'uploads' => 'uploads',
            'processed' => 'processed',
            'backups' => 'backups',
            'quarantine' => 'quarantine',
        ],
    ],

    'logging' => [
        // Log all upload attempts
        'log_uploads' => true,

        // Log processing results
        'log_processing' => true,

        // Log security events
        'log_security_events' => true,

        // Log file operations
        'log_file_operations' => true,
    ],

    'notifications' => [
        // Notify on successful uploads
        'notify_on_success' => true,

        // Notify on processing errors
        'notify_on_errors' => true,

        // Notify on security issues
        'notify_on_security_issues' => true,

        // Email notifications
        'email_notifications' => env('BLOG_UPLOAD_EMAIL_NOTIFICATIONS', true),

        // Notification recipients
        'notification_recipients' => [
            env('ADMIN_EMAIL', 'admin@academicscribe.com'),
        ],
    ],

    'ui' => [
        // Enable drag and drop
        'enable_drag_drop' => true,

        // Show upload progress
        'show_progress' => true,

        // Enable file preview
        'enable_preview' => true,

        // Auto-process after upload
        'auto_process' => false,

        // Confirm before processing
        'confirm_before_processing' => true,
    ],
];
