<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBlogPostsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blog_posts', function (Blueprint $table) {
            $table->id();
            $table->string('slug');
            $table->string('title');
            $table->string('subtitle')->nullable();
            $table->text('excerpt');
            $table->longText('content');
            $table->string('featured_image')->nullable();
            $table->string('featured_image_alt')->nullable();
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('author_id');
            $table->timestamp('published_at')->nullable();
            $table->integer('read_time')->default(0);
            $table->enum('difficulty', ['beginner', 'intermediate', 'advanced'])->default('beginner');
            $table->enum('status', ['draft', 'published', 'archived'])->default('draft');
            $table->boolean('featured')->default(0);
            $table->timestamp('featured_at')->nullable();
            $table->boolean('enable_comments')->default(1);
            $table->boolean('enable_ratings')->default(1);
            $table->json('meta_data')->nullable();
            $table->json('structured_data')->nullable();
            $table->json('social_sharing')->nullable();
            $table->json('analytics')->nullable();
            $table->json('table_of_contents')->nullable();
            $table->timestamps();
            
            $table->unique('slug', 'blog_posts_slug_unique');
            $table->foreign('author_id')->references('id')->on('blog_authors')->onDelete('cascade');
            $table->index('slug', 'blog_posts_slug_index');
            $table->index('published_at', 'blog_posts_published_at_index');
            $table->index('category_id', 'blog_posts_category_id_index');
            $table->index('status', 'blog_posts_status_index');
            $table->index(['category_id', 'published_at'], 'blog_posts_category_id_published_at_index');
            $table->index(['status', 'published_at'], 'blog_posts_status_published_at_index');
            $table->index(['status', 'featured'], 'blog_posts_status_featured_index');
            $table->index(['featured', 'published_at'], 'blog_posts_featured_published_at_index');
            
            // Fulltext index for search functionality (MySQL only)
            if (config('database.default') !== 'sqlite') {
                $table->fullText(['title', 'excerpt', 'content'], 'blog_posts_title_excerpt_content_fulltext');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_posts');
    }
}
