<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBlogPostRelatedTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blog_post_related', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('blog_post_id');
            $table->unsignedBigInteger('related_post_id');
            $table->timestamps();
            
            $table->unique(['blog_post_id', 'related_post_id'], 'blog_post_related_blog_post_id_related_post_id_unique');
            $table->foreign('blog_post_id')->references('id')->on('blog_posts')->onDelete('cascade');
            $table->foreign('related_post_id')->references('id')->on('blog_posts')->onDelete('cascade');
            $table->index('blog_post_id', 'blog_post_related_blog_post_id_index');
            $table->index('related_post_id', 'blog_post_related_related_post_id_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_post_related');
    }
}
