<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('order_number');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('writer_id')->nullable();
            $table->unsignedBigInteger('coupon_id')->nullable();
            $table->string('title', 250);
            $table->string('type_of_paper', 30);
            $table->string('subject', 200);
            $table->string('academic_level', 50);
            $table->string('urgency');
            $table->integer('pages');
            $table->text('instructions');
            $table->string('styles', 255);
            $table->datetime('dateposted');
            $table->datetime('deadline');
            $table->datetime('writer_deadline')->nullable();
            $table->string('client_timezone');
            $table->integer('sources');
            $table->double('order_amount')->default(0);
            $table->double('net_amount')->default(0);
            $table->double('writer_amount')->default(0);
            $table->double('discount')->default(0);
            $table->string('currency', 10)->default('USD');
            $table->decimal('currency_rate', 10, 6)->default(1.000000);
            $table->string('coupon', 200)->nullable();
            $table->enum('payment_status', ['paid', 'unpaid', 'refunded', 'partially_refunded'])->default('unpaid');
            $table->string('order_status', 50);
            $table->integer('powerpoint_slides')->nullable();
            $table->string('spacing', 255);
            $table->text('order_revision')->nullable();
            $table->string('payment_transaction_id')->nullable();
            $table->string('payment_method')->nullable();
            $table->timestamp('payment_date')->nullable();
            
            $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('set null')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
}
