<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPaymentImpactFieldsToAdminSettingsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('admin_settings', function (Blueprint $table) {
            $table->decimal('quality_bonus', 8, 2)->default(5.00)->after('essay_test_duration');
            $table->decimal('quality_penalty', 8, 2)->default(10.00)->after('quality_bonus');
            $table->decimal('delay_penalty_per_hour', 8, 2)->default(0.50)->after('quality_penalty');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('admin_settings', function (Blueprint $table) {
            $table->dropColumn(['quality_bonus', 'quality_penalty', 'delay_penalty_per_hour']);
        });
    }
} 