<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class UpdateMessagesSenderTypeEnum extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update the enum to include super_admin
        if (config('database.default') === 'mysql') {
            DB::statement("ALTER TABLE messages MODIFY COLUMN sender_type ENUM('client', 'writer', 'admin', 'super_admin') DEFAULT 'client'");
        }
        // For SQLite and other databases, this is handled by the schema definition
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to original enum
        if (config('database.default') === 'mysql') {
            DB::statement("ALTER TABLE messages MODIFY COLUMN sender_type ENUM('client', 'writer', 'admin') DEFAULT 'client'");
        }
        // For SQLite and other databases, this is handled by the schema definition
    }
} 