<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterCitationStyleTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_citation_style', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->unsignedBigInteger('writer_citation_style_id');
            $table->timestamps();
            
            $table->unique(['writer_profile_id', 'writer_citation_style_id'], 'writer_citation_style_unique');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
            $table->foreign('writer_citation_style_id')->references('id')->on('writer_citation_styles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_citation_style');
    }
}
