<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterPaymentAccountsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_payment_accounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->unsignedBigInteger('payment_method_id');
            $table->text('account_details')->nullable();
            $table->boolean('is_primary')->default(0);
            $table->boolean('is_verified')->default(0);
            $table->timestamps();
            
            $table->index('writer_profile_id', 'writer_payment_accounts_writer_profile_id_index');
            $table->index('payment_method_id', 'writer_payment_accounts_payment_method_id_index');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
            $table->foreign('payment_method_id')->references('id')->on('writer_payment_methods')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_payment_accounts');
    }
}
