<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderFilesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_files', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id');
            $table->string('file_name');
            $table->string('file_type');
            $table->unsignedBigInteger('uploader_id');
            $table->string('uploader_name');
            $table->string('uploader_user_type'); // client, writer, admin
            $table->string('file_url');
            $table->integer('file_size');
            $table->string('file_status')->default('pending');
            $table->string('file_category')->default('general'); // sample, instructions, draft, complete, admin
            $table->text('description')->nullable(); // Description of the file
            $table->string('access_control')->default('admin_only'); // admin_only, client_writer, client_admin, writer_admin
            $table->timestamp('date_uploaded')->useCurrent();
            
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_files');
    }
}
