<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserCouponsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_coupons', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('coupon_id');
            $table->timestamp('used_at')->useCurrent()->useCurrentOnUpdate();
            $table->decimal('order_total', 10, 2)->nullable()->comment('Order total when coupon was applied');
            $table->decimal('discount_amount', 10, 2)->nullable()->comment('Actual discount amount applied');
            $table->unsignedBigInteger('order_id')->nullable();
            $table->timestamps();
            
            $table->unique(['user_id', 'coupon_id', 'order_id'], 'unique_user_coupon_order');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('cascade');
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_coupons');
    }
}
