<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddDefaultToCouponTypeEnum extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add 'default' to the coupon_type enum
        if (config('database.default') === 'mysql') {
            DB::statement("ALTER TABLE coupons MODIFY COLUMN coupon_type ENUM('first_order', 'flash', 'referral', 'loyalty', 'anniversary', 'seasonal', 'volume', 'default')");
        }
        // For SQLite and other databases, this is handled by the schema definition
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove 'default' from the coupon_type enum
        if (config('database.default') === 'mysql') {
            DB::statement("ALTER TABLE coupons MODIFY COLUMN coupon_type ENUM('first_order', 'flash', 'referral', 'loyalty', 'anniversary', 'seasonal', 'volume')");
        }
        // For SQLite and other databases, this is handled by the schema definition
    }
}
