<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterSubjectsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_subjects', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->unsignedBigInteger('subject_id');
            $table->timestamps();
            
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
            $table->foreign('subject_id')->references('id')->on('subjects');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_subjects');
    }
}
