<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterTestRetryPeriodsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_test_retry_periods', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->timestamp('last_failed_at')->nullable();
            $table->timestamp('can_retry_after')->nullable();
            $table->timestamps();
            
            $table->index('writer_profile_id', 'writer_test_retry_periods_writer_profile_id_index');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_test_retry_periods');
    }
}
