<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterWithdrawalRequestsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_withdrawal_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('writer_id')->constrained('users')->onDelete('cascade');
            
            // Request details
            $table->decimal('requested_amount', 10, 2);
            $table->string('currency', 3)->default('USD');
            $table->date('withdrawal_date'); // 15th or 30th of the month
            
            // Status tracking
            $table->enum('status', ['requested', 'approved', 'processing', 'paid', 'rejected', 'cancelled'])->default('requested');
            
            // Payment method details
            $table->string('payment_method'); // paypal, bank_transfer, etc.
            $table->json('payment_details'); // encrypted account details
            
            // Processing information
            $table->foreignId('approved_by')->nullable()->constrained('users');
            $table->timestamp('approved_at')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamp('paid_at')->nullable();
            
            // Batch processing
            $table->unsignedBigInteger('withdrawal_batch_id')->nullable();
            $table->string('transaction_reference')->nullable();
            
            // Additional information
            $table->text('notes')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->json('metadata')->nullable();
            
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['writer_id', 'status']);
            $table->index('withdrawal_date');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_withdrawal_requests');
    }
}
