<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddWriterPaymentFieldsToOrdersTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Add writer payment specific fields (payment_status already exists)
            // Track when payment became available for writer
            $table->timestamp('writer_payment_released_at')->nullable()->after('payment_status');
            
            // Link to withdrawal batch when payment is processed
            $table->unsignedBigInteger('withdrawal_batch_id')->nullable()->after('writer_payment_released_at');
            
            // Track payment-related timestamps for writer
            $table->timestamp('writer_payment_calculated_at')->nullable()->after('withdrawal_batch_id');
            
            // Writer payment status (separate from order payment status)
            $table->enum('writer_payment_status', [
                'pending', 
                'pending_revision', 
                'available', 
                'withdrawn', 
                'disputed'
            ])->default('pending')->after('writer_payment_calculated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'writer_payment_released_at',
                'withdrawal_batch_id',
                'writer_payment_calculated_at',
                'writer_payment_status'
            ]);
        });
    }
}
