<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEnhancedRevisionFieldsToOrderRevisionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_revisions', function (Blueprint $table) {
            // Add revision priority field
            $table->enum('revision_priority', ['low', 'medium', 'high'])->default('medium')->after('revision_type');
            
            // Add revision section field for specific document parts
            $table->text('revision_section')->nullable()->after('revision_priority');
            
            // Rename due_date to revision_deadline for consistency
            $table->renameColumn('due_date', 'revision_deadline');
            
            // Add revision status enum (replacing the existing status field)
            $table->enum('revision_status', ['requested', 'acknowledged', 'in_progress', 'submitted', 'reviewed'])->default('requested')->after('status');
            
            // Add revision metadata field
            $table->json('revision_metadata')->nullable()->after('admin_notes');
            
            // Add additional timestamp fields for granular tracking
            $table->timestamp('revision_acknowledged_at')->nullable()->after('requested_at');
            $table->timestamp('revision_submitted_at')->nullable()->after('started_at');
            $table->timestamp('revision_reviewed_at')->nullable()->after('completed_at');
            
            // Add indexes for performance
            $table->index(['revision_priority']);
            $table->index(['revision_status']);
            $table->index(['revision_deadline']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_revisions', function (Blueprint $table) {
            // Drop added fields
            $table->dropColumn([
                'revision_priority',
                'revision_section',
                'revision_status',
                'revision_metadata',
                'revision_acknowledged_at',
                'revision_submitted_at',
                'revision_reviewed_at'
            ]);
            
            // Rename column back
            $table->renameColumn('revision_deadline', 'due_date');
            
            // Drop indexes
            $table->dropIndex(['revision_priority']);
            $table->dropIndex(['revision_status']);
            $table->dropIndex(['revision_deadline']);
        });
    }
}
