<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageMediaTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_media', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id')->constrained()->onDelete('cascade');
            $table->enum('media_type', ['image', 'video', 'document'])->default('image');
            $table->string('file_path');
            $table->string('alt_text')->nullable();
            $table->string('title')->nullable();
            $table->text('caption')->nullable();
            $table->string('usage_context')->nullable(); // hero, benefits, process, etc.
            $table->json('optimization_settings')->nullable(); // different sizes/formats
            $table->boolean('is_optimized')->default(false);
            $table->unsignedBigInteger('file_size')->nullable();
            $table->string('mime_type')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['page_id']);
            $table->index(['media_type']);
            $table->index(['usage_context']);
            $table->index(['is_optimized']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_media');
    }
}
