<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('admin_settings', function (Blueprint $table) {
            // Google Tag Manager
            $table->boolean('enable_gtm')->default(false)->after('enable_stripe_payment');
            $table->string('gtm_id')->nullable()->after('enable_gtm');
            $table->integer('gtm_delay')->default(2000)->after('gtm_id'); // milliseconds
            
            // Tawk.to Chat
            $table->boolean('enable_tawkto')->default(false)->after('gtm_delay');
            $table->string('tawkto_property_id')->nullable()->after('enable_tawkto');
            $table->string('tawkto_widget_id')->nullable()->after('tawkto_property_id');
            $table->integer('tawkto_delay')->default(5000)->after('tawkto_widget_id'); // milliseconds
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('admin_settings', function (Blueprint $table) {
            $table->dropColumn([
                'enable_gtm',
                'gtm_id',
                'gtm_delay',
                'enable_tawkto',
                'tawkto_property_id',
                'tawkto_widget_id',
                'tawkto_delay',
            ]);
        });
    }
};


