<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $blocks = [
            'affordable' => [
                'title' => 'Related Academic Writing Services',
                'description' => 'Explore more essay services designed to match your budget and timeline.',
                'linkCategory' => 'related',
                'links' => [
                    [
                        'title' => 'Essay Writing Service',
                        'url' => '/services/essay-writing',
                        'description' => 'End-to-end essay planning, drafting, and editing support for any subject.',
                        'is_active' => true,
                    ],
                    [
                        'title' => 'Buy Essays Online',
                        'url' => '/services/buy-essays-online',
                        'description' => 'Secure online ordering with transparent pricing and plagiarism-free guarantees.',
                        'is_active' => true,
                    ],
                    [
                        'title' => 'Cheap Essays Online',
                        'url' => '/services/cheap-essays-online',
                        'description' => 'Budget-friendly essay packages that keep quality, originality, and deadlines intact.',
                        'is_active' => true,
                    ],
                ],
            ],
            'buy' => [
                'title' => 'Related Essay Writing Services',
                'description' => 'Looking for more writing options? Continue your journey with these popular services.',
                'linkCategory' => 'related',
                'links' => [
                    [
                        'title' => 'Essay Writing Service',
                        'url' => '/services/essay-writing',
                        'description' => 'Custom essays crafted by subject experts with guaranteed originality.',
                        'is_active' => true,
                    ],
                    [
                        'title' => 'Affordable Essay Writing',
                        'url' => '/services/affordable-essay-writing',
                        'description' => 'High-quality essays priced for students who need predictable, fair rates.',
                        'is_active' => true,
                    ],
                    [
                        'title' => 'Cheap Essays Online',
                        'url' => '/services/cheap-essays-online',
                        'description' => 'Entry-level pricing without sacrificing structure, research, or support.',
                        'is_active' => true,
                    ],
                ],
            ],
            'cheap' => [
                'title' => 'More Essay Writing Support',
                'description' => 'Compare pricing, turnaround, and writer tiers across our essay services.',
                'linkCategory' => 'related',
                'links' => [
                    [
                        'title' => 'Essay Writing Service',
                        'url' => '/services/essay-writing',
                        'description' => 'Full-scope essay writing with research, citations, and polished formatting.',
                        'is_active' => true,
                    ],
                    [
                        'title' => 'Affordable Essay Writing',
                        'url' => '/services/affordable-essay-writing',
                        'description' => 'Balanced pricing and premium QA processes for students on a budget.',
                        'is_active' => true,
                    ],
                    [
                        'title' => 'Buy Essays Online',
                        'url' => '/services/buy-essays-online',
                        'description' => 'Streamlined ordering with secure payments and flexible delivery windows.',
                        'is_active' => true,
                    ],
                ],
            ],
        ];

        foreach ($blocks as $prefix => $content) {
            $payload = $content;
            $payload['description_html'] = $payload['description'];

            DB::table('page_content')
                ->where('block_key', $prefix . '_related_services')
                ->update([
                    'content' => json_encode($payload),
                ]);
        }
    }

    public function down(): void
    {
        // No rollback required.
    }
};










