<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $overviews = [
            'buy' => [
                'title' => 'Why Buy Essays Online from Academic Scribe?',
                'description_html' => '<p>If you are comparing where to buy essays online, quality matters as much as convenience. Academic Scribe combines vetted writers, structured workflows, and transparent guarantees so you always know exactly what you are purchasing.</p><p>Partnering with us means more than receiving a document—we become your academic support team, delivering original analysis, polished writing, and specialist guidance for every assignment.</p>',
                'features' => [
                    [
                        'title' => 'Original, Custom-Written Content',
                        'description' => '<p>Every essay is built from scratch to your rubric. We never reuse or resell papers and back every order with originality reports.</p>',
                        'icon' => 'FileText',
                    ],
                    [
                        'title' => 'Vetted Writer Network',
                        'description' => '<p>Only subject-qualified writers with advanced degrees, native-level English, and proven delivery records join our team.</p>',
                        'icon' => 'User',
                    ],
                    [
                        'title' => 'Secure, Streamlined Process',
                        'description' => '<p>256-bit SSL encryption, verified payment gateways, and anonymised writer matching keep every order safe from start to finish.</p>',
                        'icon' => 'CheckCircle',
                    ],
                    [
                        'title' => 'Quality Assurance',
                        'description' => '<p>Manual editing, automated grammar checks, formatting verification, and plagiarism scanning ensure each delivery meets your standards.</p>',
                        'icon' => 'Award',
                    ],
                ],
            ],
            'cheap' => [
                'title' => 'Affordable Essay Support without Compromise',
                'description_html' => '<p>Our cheap essay writing service focuses on smart efficiencies instead of cutting corners. You receive the same academic expertise, rigorous QA, and on-time delivery as our premium plans—just packaged for tighter budgets.</p><p>Transparent pricing, clear communication, and flexible deadlines mean you can stay on top of coursework without sacrificing quality.</p>',
                'features' => [
                    [
                        'title' => 'Budget-Friendly Pricing',
                        'description' => '<p>Optimised workflows, smart scheduling, and bulk discounts keep your costs predictable while protecting standards.</p>',
                        'icon' => 'Clock',
                    ],
                    [
                        'title' => 'Qualified Academic Writers',
                        'description' => '<p>Work with subject specialists who hold Master’s or PhD degrees and understand the nuances of academic research and writing.</p>',
                        'icon' => 'User',
                    ],
                    [
                        'title' => 'Flexible Delivery Options',
                        'description' => '<p>Choose rush orders when deadlines surprise you or extended timelines for maximum savings—all with the same quality controls.</p>',
                        'icon' => 'BookOpen',
                    ],
                    [
                        'title' => 'Quality & Originality Guaranteed',
                        'description' => '<p>Every order includes plagiarism checks, formatting verification, and free revisions so you never trade reliability for price.</p>',
                        'icon' => 'CheckCircle',
                    ],
                ],
            ],
        ];

        foreach ($overviews as $prefix => $content) {
            DB::table('page_content')
                ->where('block_key', $prefix . '_overview')
                ->update([
                    'content' => json_encode([
                        'title' => $content['title'],
                        'description' => $content['description_html'],
                        'description_html' => $content['description_html'],
                        'features' => $content['features'],
                    ]),
                ]);
        }
    }

    public function down(): void
    {
        // No rollback required.
    }
};










