<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $benefits = [
            'buy' => [
                'title' => 'Why Students Buy Essays Online with Confidence',
                'description_html' => '<p>Buying essays online should feel safe, predictable, and worthwhile. We combine advanced writers, rigorous QA, and transparent guarantees so you receive polished work every time.</p>',
                'benefits' => [
                    [
                        'icon' => 'FileText',
                        'title' => 'Custom Essays From Scratch',
                        'description_html' => '<p>Every order is written uniquely to your brief—no templates, no recycled content, and plagiarism checks on delivery.</p>',
                    ],
                    [
                        'icon' => 'User',
                        'title' => 'Specialist Writing Team',
                        'description_html' => '<p>Subject-qualified writers (Master’s & PhD) with native-level English and proven academic writing experience handle your assignment.</p>',
                    ],
                    [
                        'icon' => 'CheckCircle',
                        'title' => 'Secure, Confidential Process',
                        'description_html' => '<p>Encrypted payments, anonymous writer matching, and strict privacy policies keep your data safe while you order.</p>',
                    ],
                    [
                        'icon' => 'Award',
                        'title' => 'Multi-Layer Quality Review',
                        'description_html' => '<p>Human editors and automated tools verify grammar, structure, formatting, and originality before you receive the final draft.</p>',
                    ],
                ],
                'ctaText' => 'Compare pricing',
                'ctaLink' => '/pricing',
            ],
            'cheap' => [
                'title' => 'Affordable Essay Help That Still Delivers Quality',
                'description_html' => '<p>Cutting costs should never mean cutting standards. Our cheap essay writing plans protect quality through smart efficiencies and veteran academic writers.</p>',
                'benefits' => [
                    [
                        'icon' => 'Clock',
                        'title' => 'Flexible Turnaround Options',
                        'description_html' => '<p>Rush delivery when deadlines surprise you or extended timelines for maximum savings—always on schedule.</p>',
                    ],
                    [
                        'icon' => 'User',
                        'title' => 'Degree-Level Writers Only',
                        'description_html' => '<p>Work with specialists who understand your subject, citation style, and academic expectations—even on budget-friendly plans.</p>',
                    ],
                    [
                        'icon' => 'CheckCircle',
                        'title' => 'Transparent Pricing & Guarantees',
                        'description_html' => '<p>No hidden fees, plagiarism reports available, and a quality-match promise backed by free revisions or your money back.</p>',
                    ],
                    [
                        'icon' => 'BookOpen',
                        'title' => 'Comprehensive Support Resources',
                        'description_html' => '<p>Guides, outline checkpoints, and 24/7 support help you stay in control from initial order to final submission.</p>',
                    ],
                ],
                'ctaText' => 'Explore affordable plans',
                'ctaLink' => '/pricing',
            ],
        ];

        foreach ($benefits as $prefix => $content) {
            $payload = [
                'title' => $content['title'],
                'description' => $content['description_html'],
                'description_html' => $content['description_html'],
                'benefits' => $content['benefits'],
                'ctaText' => $content['ctaText'],
                'ctaLink' => $content['ctaLink'],
            ];

            DB::table('page_content')
                ->where('block_key', $prefix . '_benefits')
                ->update([
                    'content' => json_encode($payload),
                ]);
        }
    }

    public function down(): void
    {
        // No rollback required.
    }
};










