<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        $descriptionHtml = <<<'HTML'
<p><strong>Ready to get started?</strong></p>
<p>Ready to buy essays online? Buy essay writing service solutions from Academic Scribe today and experience the difference quality makes.</p>
<p><strong>Why buy essays online from us?</strong></p>
<p>When you buy custom essay online through Academic Scribe, you get the same guarantees trusted by students who need originality, speed, and expert guidance on demand.</p>
HTML;

        $benefits = [
            [
                'icon' => 'ShieldCheck',
                'title' => '100% Original Content',
                'description_html' => '<p>Every essay is custom-written from scratch. We never resell papers or reuse templates, and each delivery is backed by industry-standard plagiarism checks. Request a plagiarism report add-on any time you need documentation.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'Clock',
                'title' => 'Fast Turnaround',
                'description_html' => '<p>Need an essay urgently? Receive finished work in as little as 6 hours when timelines are tight. Standard delivery (3–7 days) offers the best value, while extended deadlines (8+ days) provide maximum writer attention.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'Users',
                'title' => 'Expert Writers Only',
                'description_html' => '<p>Our network includes Master’s and PhD-level experts. Every writer passes credential checks, subject-matter testing, sample reviews, and on-time delivery audits so you’re matched with someone qualified in your discipline.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'DollarSign',
                'title' => 'Transparent Pricing',
                'description_html' => '<p>No hidden fees or surprise charges. Your quote reflects essay length, academic level, deadline, and subject complexity. You always know the total before you place your order.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'CheckCircle',
                'title' => 'Money-Back Guarantee',
                'description_html' => '<p>If revisions do not resolve a quality issue, you receive a full refund. We stand behind every order with a satisfaction guarantee and documented revision process.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'Shield',
                'title' => 'Secure & Confidential',
                'description_html' => '<p>Payments are encrypted (256-bit SSL) and your identity stays private. Writer-client matching is anonymous, your files are stored securely, and sensitive details are protected end-to-end.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'Headset',
                'title' => '24/7 Customer Support',
                'description_html' => '<p>Get help whenever you need it. Our support team handles order questions, writer requests, progress updates, and revision coordination around the clock.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'CheckCircle',
                'title' => 'Free Revisions',
                'description_html' => '<p>Not satisfied with the first draft? Request free revisions within 48 hours of delivery. Provide specific feedback and your writer will update the essay until it matches your expectations.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'BookOpen',
                'title' => 'Multiple Citation Styles',
                'description_html' => '<p>We format essays in APA, MLA, Chicago/Turabian, Harvard, IEEE, AMA, and more. Share your institution’s template or special instructions and we handle the rest.</p>',
                'is_active' => true,
            ],
            [
                'icon' => 'Percent',
                'title' => 'Progress Tracking',
                'description_html' => '<p>Track every milestone in real time. View order status, check when your writer starts, monitor draft submissions, and receive notifications the moment your essay is ready.</p>',
                'is_active' => true,
            ],
        ];

        $guarantees = [
            'title' => 'Our Guarantees',
            'description' => 'When you buy essays online from Academic Scribe, you’re protected at every step:',
            'items' => [
                [
                    'title' => 'Originality Guarantee',
                    'description_html' => '<p>Every paper is written from scratch and checked with plagiarism detection tools. Optional reports prove authenticity when you need documentation.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'On-Time Delivery',
                    'description_html' => '<p>We hit 98% of deadlines. If we ever run behind schedule, you qualify for partial or full refunds depending on the delay.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'Quality Match Promise',
                    'description_html' => '<p>If the delivered work doesn’t align with the agreed brief, we apply revisions immediately or refund the order. Quality is part of the contract.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'Money-Back Guarantee',
                    'description_html' => '<p>If revisions still miss the mark, you receive a full refund. Your investment stays protected until you sign off on the final essay.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'Privacy Guarantee',
                    'description_html' => '<p>Your identity stays confidential. We never share your data, resell your content, or expose chat history beyond your support team.</p>',
                    'is_active' => true,
                ],
            ],
        ];

        $quickStart = [
            'title' => 'Get Started Now',
            'description_html' => '<p>Place your order in under 3 minutes:</p>',
            'footnote' => 'No registration required for quotes. See pricing instantly, then decide.',
            'steps' => [
                [
                    'title' => 'Fill out the quick order form',
                    'description_html' => '<p>Share your assignment details, deadline, academic level, and any special instructions.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'Get an instant price quote',
                    'description_html' => '<p>See transparent pricing before you commit. Adjust options until the plan fits your budget and goals.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'Make secure payment',
                    'description_html' => '<p>Pay through encrypted checkout (Stripe, PayPal, or major cards). Your financial data stays protected.</p>',
                    'is_active' => true,
                ],
                [
                    'title' => 'Receive your essay on time',
                    'description_html' => '<p>Track progress, review drafts, and download the final essay on or before your deadline.</p>',
                    'is_active' => true,
                ],
            ],
        ];

        $offer = [
            'badge' => 'Limited-Time Offer',
            'title' => 'Save 15% on your first order when you buy essays online today.',
            'description_html' => '<p>Use code <strong>FIRST15</strong> at checkout and lock in professional support from vetted writers.</p>',
            'code' => 'FIRST15',
            'note' => 'Limited writer availability this week—secure your spot now.',
            'ctaText' => 'Get started now',
            'ctaLink' => '/place-order',
            'sidebarTitle' => 'Ready to buy essays online?',
            'sidebarDescription' => 'Join thousands of students who rely on Academic Scribe for custom-written essays delivered on time.',
            'sidebarFootnote' => 'Confidential • Money-back guarantee • Free revisions',
            'sidebarCtaText' => 'Secure my discount',
            'sidebarCtaLink' => '/place-order',
        ];

        $supportDescription = <<<'HTML'
<p>Our support team is available 24/7 to help you:</p>
<ul>
<li>Understand our process</li>
<li>Get pricing quotes and promo details</li>
<li>Choose the right writer and timeline</li>
<li>Track your order status</li>
<li>Request revisions or escalations</li>
</ul>
HTML;

        $support = [
            'title' => 'Still Have Questions?',
            'description_html' => $supportDescription,
            'channels' => [
                [
                    'label' => 'Live chat',
                    'value' => 'Chat with us in real time for immediate answers.',
                    'href' => '/contact?channel=chat',
                    'type' => 'chat',
                    'is_active' => true,
                ],
                [
                    'label' => 'Email support',
                    'value' => 'support@academicscribe.com',
                    'href' => 'mailto:support@academicscribe.com',
                    'type' => 'email',
                    'is_active' => true,
                ],
                [
                    'label' => 'Phone',
                    'value' => '1-800-XXX-XXXX (Mon–Fri, business hours)',
                    'href' => 'tel:18009999999',
                    'type' => 'phone',
                    'is_active' => true,
                ],
            ],
        ];

        $trustSignals = [
            [
                'value' => '⭐ 4.8/5',
                'label' => 'Average customer rating',
                'description' => 'Based on 2,000+ verified reviews from students worldwide.',
                'is_active' => true,
            ],
            [
                'value' => '✅ 150,000+',
                'label' => 'Essays delivered',
                'description' => 'Academic, admissions, and business writing delivered since 2012.',
                'is_active' => true,
            ],
            [
                'value' => '🎯 98%',
                'label' => 'On-time delivery rate',
                'description' => 'Deadline control backed by dedicated writer scheduling and QA support.',
                'is_active' => true,
            ],
            [
                'value' => '🔒 100%',
                'label' => 'Secure checkout',
                'description' => '256-bit SSL encryption with Stripe, PayPal, and major card processors.',
                'is_active' => true,
            ],
        ];

        $payload = [
            'eyebrow' => 'Why choose us',
            'title' => 'Benefits of Buying Essays Online from Academic Scribe',
            'description' => $descriptionHtml,
            'description_html' => $descriptionHtml,
            'benefits' => $benefits,
            'guarantees' => $guarantees,
            'quickStart' => $quickStart,
            'offer' => $offer,
            'support' => $support,
            'trustSignals' => $trustSignals,
            'ctaText' => 'Get started now',
            'ctaLink' => '/place-order',
        ];

        DB::table('page_content')
            ->where('block_key', 'buy_benefits')
            ->update(['content' => json_encode($payload)]);
    }

    public function down(): void
    {
        //
    }
};

