<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Billing address fields
            $table->string('billing_street_address')->nullable();
            $table->string('billing_city')->nullable();
            $table->string('billing_state_province')->nullable();
            $table->string('billing_postal_code')->nullable();
            $table->unsignedBigInteger('billing_country_id')->nullable();
            $table->string('tax_id')->nullable(); // VAT number, tax ID, etc.
            $table->string('company_name')->nullable();
            
            $table->foreign('billing_country_id')->references('id')->on('countries')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['billing_country_id']);
            $table->dropColumn([
                'billing_street_address',
                'billing_city',
                'billing_state_province',
                'billing_postal_code',
                'billing_country_id',
                'tax_id',
                'company_name'
            ]);
        });
    }
};