<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_preferences', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            
            // Default order settings
            $table->unsignedBigInteger('default_academic_level_id')->nullable();
            $table->unsignedBigInteger('default_paper_type_id')->nullable();
            $table->unsignedBigInteger('default_subject_id')->nullable();
            $table->string('default_spacing', 20)->nullable()->default('double'); // single, double, 1.5
            $table->string('default_citation_style', 100)->nullable();
            $table->unsignedBigInteger('default_language_id')->nullable();
            $table->string('default_currency', 10)->nullable()->default('USD');
            
            // Writer preferences
            $table->boolean('auto_assign_writer')->default(false);
            $table->text('preferred_writer_ids')->nullable(); // JSON array of writer IDs
            $table->text('blacklisted_writer_ids')->nullable(); // JSON array of writer IDs
            
            // Deadline preferences
            $table->integer('default_deadline_buffer_hours')->nullable()->default(24); // Hours buffer for deadlines
            
            // Privacy & Communication preferences
            $table->boolean('allow_writer_contact_after_completion')->default(true);
            $table->boolean('show_order_history_to_writers')->default(false);
            $table->boolean('profile_visible_to_writers')->default(true);
            $table->string('preferred_communication_method', 50)->nullable()->default('in_app'); // in_app, email, both
            
            // Display preferences
            $table->string('timezone', 100)->nullable();
            $table->string('date_format', 50)->nullable()->default('Y-m-d');
            $table->string('time_format', 20)->nullable()->default('H:i');
            $table->string('theme', 20)->nullable()->default('auto'); // light, dark, auto
            
            // Invoice preferences
            $table->boolean('auto_send_invoices')->default(true);
            $table->string('invoice_format', 50)->nullable()->default('pdf'); // pdf, email, both
            
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('default_academic_level_id')->references('id')->on('academic_levels')->onDelete('set null');
            $table->foreign('default_paper_type_id')->references('id')->on('paper_types')->onDelete('set null');
            $table->foreign('default_subject_id')->references('id')->on('subjects')->onDelete('set null');
            $table->foreign('default_language_id')->references('id')->on('languages')->onDelete('set null');
            $table->unique('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_preferences');
    }
};