<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notification_preferences', function (Blueprint $table) {
            // Add user_id and foreign key if not exists
            if (!Schema::hasColumn('notification_preferences', 'user_id')) {
                $table->unsignedBigInteger('user_id')->after('id');
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->unique('user_id');
            }
            
            // Order notifications
            if (!Schema::hasColumn('notification_preferences', 'order_status_updates')) {
                $table->boolean('order_status_updates')->default(true)->after('user_id');
                $table->boolean('order_status_updates_email')->default(true);
                $table->boolean('order_status_updates_in_app')->default(true);
                
                $table->boolean('writer_assignment')->default(true);
                $table->boolean('writer_assignment_email')->default(true);
                $table->boolean('writer_assignment_in_app')->default(true);
                
                $table->boolean('new_bids')->default(true);
                $table->boolean('new_bids_email')->default(true);
                $table->boolean('new_bids_in_app')->default(true);
                
                $table->boolean('deadline_reminders')->default(true);
                $table->boolean('deadline_reminders_email')->default(true);
                $table->boolean('deadline_reminders_in_app')->default(true);
                
                $table->boolean('order_completion')->default(true);
                $table->boolean('order_completion_email')->default(true);
                $table->boolean('order_completion_in_app')->default(true);
                
                $table->boolean('revision_requests')->default(true);
                $table->boolean('revision_requests_email')->default(true);
                $table->boolean('revision_requests_in_app')->default(true);
                
                // Payment notifications
                $table->boolean('payment_confirmations')->default(true);
                $table->boolean('payment_confirmations_email')->default(true);
                $table->boolean('payment_confirmations_in_app')->default(true);
                
                $table->boolean('payment_failures')->default(true);
                $table->boolean('payment_failures_email')->default(true);
                $table->boolean('payment_failures_in_app')->default(true);
                
                $table->boolean('refunds')->default(true);
                $table->boolean('refunds_email')->default(true);
                $table->boolean('refunds_in_app')->default(true);
                
                $table->boolean('invoice_ready')->default(true);
                $table->boolean('invoice_ready_email')->default(true);
                $table->boolean('invoice_ready_in_app')->default(true);
                
                // Communication notifications
                $table->boolean('new_messages')->default(true);
                $table->boolean('new_messages_email')->default(true);
                $table->boolean('new_messages_in_app')->default(true);
                
                $table->boolean('writer_questions')->default(true);
                $table->boolean('writer_questions_email')->default(true);
                $table->boolean('writer_questions_in_app')->default(true);
                
                // System notifications
                $table->boolean('system_announcements')->default(true);
                $table->boolean('system_announcements_email')->default(true);
                $table->boolean('system_announcements_in_app')->default(true);
                
                $table->boolean('promotional_emails')->default(true);
                $table->boolean('coupon_alerts')->default(true);
                $table->boolean('coupon_alerts_email')->default(true);
                $table->boolean('coupon_alerts_in_app')->default(true);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notification_preferences', function (Blueprint $table) {
            $columns = [
                'user_id', 'order_status_updates', 'order_status_updates_email', 'order_status_updates_in_app',
                'writer_assignment', 'writer_assignment_email', 'writer_assignment_in_app',
                'new_bids', 'new_bids_email', 'new_bids_in_app',
                'deadline_reminders', 'deadline_reminders_email', 'deadline_reminders_in_app',
                'order_completion', 'order_completion_email', 'order_completion_in_app',
                'revision_requests', 'revision_requests_email', 'revision_requests_in_app',
                'payment_confirmations', 'payment_confirmations_email', 'payment_confirmations_in_app',
                'payment_failures', 'payment_failures_email', 'payment_failures_in_app',
                'refunds', 'refunds_email', 'refunds_in_app',
                'invoice_ready', 'invoice_ready_email', 'invoice_ready_in_app',
                'new_messages', 'new_messages_email', 'new_messages_in_app',
                'writer_questions', 'writer_questions_email', 'writer_questions_in_app',
                'system_announcements', 'system_announcements_email', 'system_announcements_in_app',
                'promotional_emails', 'coupon_alerts', 'coupon_alerts_email', 'coupon_alerts_in_app',
            ];
            
            foreach ($columns as $column) {
                if (Schema::hasColumn('notification_preferences', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};