<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('admin_settings', function (Blueprint $table) {
            // Comm100 Live Chat
            $table->boolean('enable_comm100')->default(false)->after('tawkto_delay');
            $table->string('comm100_site_id')->nullable()->after('enable_comm100');
            $table->string('comm100_code_plan')->nullable()->after('comm100_site_id');
            $table->string('comm100_div_id')->nullable()->after('comm100_code_plan');
            $table->integer('comm100_delay')->default(5000)->after('comm100_div_id'); // milliseconds
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('admin_settings', function (Blueprint $table) {
            $table->dropColumn([
                'enable_comm100',
                'comm100_site_id',
                'comm100_code_plan',
                'comm100_div_id',
                'comm100_delay',
            ]);
        });
    }
};
